# -*- coding: utf-8 -*-
# Inicializa a BD local (cria tabela se não existir)
import os, sqlite3
DATA_DIR = os.path.join(os.path.dirname(__file__), "data")
DB_PATH = os.path.join(DATA_DIR, "products.sqlite")
os.makedirs(DATA_DIR, exist_ok=True)
conn = sqlite3.connect(DB_PATH)
c = conn.cursor()
c.execute("""
    CREATE TABLE IF NOT EXISTS products (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        shop TEXT,
        name TEXT,
        price_eur REAL,
        price_text TEXT,
        url TEXT,
        inserted_at TEXT
    )
""")
c.execute("CREATE INDEX IF NOT EXISTS idx_products_name ON products(name)")
c.execute("CREATE INDEX IF NOT EXISTS idx_products_price ON products(price_eur)")
conn.commit()
conn.close()
print("[OK] BD preparada em", DB_PATH)
